/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stormedpanda.simplyjetpacks.item.JetpackItem;
import stormedpanda.simplyjetpacks.util.JetpackUtil;

public class PacketUpdateThrottle {
    private final int throttleValue;

    public PacketUpdateThrottle(int throttleValue) {
        this.throttleValue = throttleValue;
    }

    public static PacketUpdateThrottle fromBytes(PacketBuffer buffer) {
        return new PacketUpdateThrottle(buffer.readInt());
    }

    public static void toBytes(PacketUpdateThrottle message, PacketBuffer buffer) {
        buffer.writeInt(message.throttleValue);
    }

    public static void handle(PacketUpdateThrottle message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            Item item;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (item = (stack = JetpackUtil.getFromBothSlots((PlayerEntity)player)).func_77973_b()) instanceof JetpackItem) {
                JetpackItem jetpack = (JetpackItem)item;
                jetpack.setThrottle(stack, message.throttleValue);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

